﻿# --------------------------------------------------------------------
# -- Python-Script-Datei
# -- Neu erstellt 
# -- Ersteller: username
# -- Kommentar: .
# --------------------------------------------------------------------
import sys
if 'DIAdem' in sys.modules:
    from DIAdem import Application as dd, Utils as ddu

    if dd.AppEnableScriptDebugger:
        import debugpy
        debugpy.configure(python = ddu.get_python_exe_path())
        if not debugpy.is_client_connected():
            try:
                debugpy.listen(5678)
            except:
                pass
            debugpy.wait_for_client()

# --------------------------------------------------------------------
# -- Beginn des Anwendercodes --

#-------------------------------------------------------------------------------
# Anwenderbefehl zur Markierung von Min-/Max-Werten einer Tabelle
# Context: Enthält alle notwendigen Parameter zur jeweiligen Umgebung, 
# in der das Event verwendet wird. Hier u.a. die Tabellenparameter
# Cell: Enthält alle Parameter der aktuellen darzustellenden Cell

def TABLEONDRAWINGCELLMINMAX(Content, Cell):
  # Einstellungen der aktuellen Tabellenspalte
  oSettings = Content.Table.Columns.Item(dd.D2TabCol).Settings
  
  # aktueller Kanal der darzustellenden Werte
  oCurrChn  = dd.Data.GetChannel(Content.Table.Columns(dd.D2TabCol).Channel.Reference)
  
  # ist der aktuell darzustellende Wert das Kanalmaximum?
  if  dd.ValEqual(dd.val(Cell.Value), oCurrChn.Maximum):
    # Hintergrundfarbe soll ROT sein
    oSettings.BackgroundColor.SetRGBColor(dd.RGB(250, 125, 135))
  # ist der aktuell darzustellende Wert das Kanalminimum?
  elif dd.ValEqual(dd.val(Cell.Value), oCurrChn.Minimum):
    # Hintergrundfarbe soll GRÜN sein
    oSettings.BackgroundColor.SetRGBColor(dd.RGB(150, 200, 0))
  else:
    # in allen anderen Fälle ist die Hintergrundfarbe Hellgrau
    oSettings.BackgroundColor.SetRGBColor(dd.RGB(245, 245, 245))
